#!/usr/bin/perl -w

#################################################################################
# (c) St. Wagner, 2005								#
# stwagner@openst.de								#
#################################################################################

use strict;

use modules::Config;
use modules::Formular;

use CGI;
use CGI::Carp 'fatalsToBrowser';
use CGI qw(:standard :escapeHTML);

#################################################################################

my $q = new CGI;

print $q->header();

&print_form();

#if(($step == 1) 
#   && (&check_values())) {
#    # check values and confirm
#    $step = 2;
#    &print_confirm();
#}
#elsif($step == 2) {
#

#} 
#else {
#    &print_form();
#}


#################################################################################
#################################################################################




#################################################################################
sub print_form {
    
    my $zeile;
    
    open(TEMPLATE, "< $config{'template_file'}") or die ("Template $config{'template_file'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/iog) {
	    print $1;
	    unless(&process_parameter($2)) {
		print "<!-- ### $2 ### -->";
	    }
	    print $3;
	}
	else {
	    print $zeile;
	}
    }       
}



sub process_parameter {
    my ($parameter) = @_;

    if ($parameter eq 'FORMULAR') {
	&formular_process($q);
	return(1);
    }
    
    return(0);
}






sub print_confirm {
    my $zeile;

    open(TEMPLATE, "< $config{'template_confirm'}") 
	|| die ("Template $config{'template_confirm'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	chomp($zeile);
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/iog) {
	    print $1;
	    if(($2 eq 'FORM_BEGIN') 
	       || ($2 eq 'FORM_END')
	       || ($2 eq 'SUBMIT')
	       || ($2 eq 'BACK')) {
#		&print_formular($2, 'CONFIRM'); 
	    }
	    elsif(($q->param($2) ne '') || ($config_display_form{$2} == 1)){
		print $q->param($2);
		print '<input type="hidden" name="'.$2.'" value="'.escapeHTML($q->param($2)).'">';
	    }
	    print $3."\n";
	}
	else {
	    print $zeile."\n";
	}
    }       
}


sub print_end {
    my ($status) = @_;

    my $zeile;
    my $zeile2;

    open(TEMPLATE, "< $config{'template_end'}") 
	|| die ("Template $config{'template_end'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	chomp($zeile);
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/iog) {
	    print $1;
	    if ($status eq 'OK') {
		open(TEMPLATE2, "< $config{'template_message_ok'}") 
		    || die ("Template $config{'template_message_ok'} not found.");
		
		while ( $zeile2 = <TEMPLATE2> ) {
		    chomp($zeile2);
		    if ($zeile2 =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/iog) {
			print $1;
			if(($q->param($2) ne '') || ($config_display_form{$2} == 1)){
			    print escapeHTML($q->param($2));
			}
			print $3."\n";
		    }
		    else {
			print $zeile2;
		    }
		}
		close(TEMPLATE2);
	    }
	    elsif ($status eq 'REREGISTRATION') {
		open(TEMPLATE2, "< $config{'template_message_failure'}") 
		    || die ("Template $config{'template_message_failure'} not found.");
		print <TEMPLATE2>;
		close(TEMPLATE2);
	    }
	}
	else {
	    print $zeile."\n";
	}       
    }
    close(TEMPLATE);
}




#-------------------------------------------------------------------------------
sub check_values {
#    if(&formular_person_check($q) == 0) {
##	print "person-Fehler";
#	return(0);
#    }
#    if(&formular_address_check($q) == 0) {
##	print "address-Fehler";
#	return(0);
#    }
#    if(&formular_payment_check($q) == 0) {
##	print "payment-Fehler";
#	return(0);
#    }
#

    return(1);
}

