package modules::Registration;

###################################################
#
#
###################################################

use strict;
use locale;

use modules::Config;
use modules::Subfunctions;

require Exporter;
use vars qw(@ISA @EXPORT $VERSION
	    &formular_registration
	    );


@ISA    = qw(Exporter);
@EXPORT = qw(
	    &formular_registration

	     );

$VERSION = 0.1;


my $q;

####################################################
#
####################################################

sub formular_registration {
    ($q) = @_;
    my $zeile;

    my $l1;
    my $l2;
    my $l3;
    my $input;
    my $error;

    open(TEMPLATE, "< $config{'template_registration'}") ||
	die ("Template $config{'template_registration'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)(<!--\s*### \w+ ###\s*-->)(.*)$/iog) {
	    $l1 = $1;
	    $input = $2;
	    $l2 = $3;
	    $error = $4;
	    $l3 = $5;
	    if(defined($error)) {
		if($zeile =~ m/^<!--\s*### (\w+) ###\s*-->$/iog) {
		   $error = $1;
	       }
	    }
	    &print_formular($input, $l1, $l2, $error, $l3);
	}
	else {
	    print $zeile;
	}
    }       


}


################################################################################

sub print_formular {
    my ($input, $l1, $l2, $error, $l3) = @_;

    if ($input eq 'GENDER') {
	if($config_display_form{'PERSON_GENDER'}) {
	    print $l1;
	    &gender($error, $l2);
	    print $l3."\n";
	}
    }
    elsif ($input eq 'SURNAME') {
	if($config_display_form{'PERSON_SURNAME'}) {
	    print $l1;
	    &surname($error, $l2);
	    print $l3."\n";
	}
    }
    elsif ($input eq 'FIRSTNAME') {
	if($config_display_form{'PERSON_FIRSTNAME'}) {
	    print $l1;
	    &firstname($error, $l2);
	    print $l3."\n";
	}
    }
    elsif ($input eq 'TITLE') {
#	if($config_display_form{'PERSON_TITLE'}) {
	    print $l1;
	    &title($error, $l2);
	    print $l3."\n";
#	}
    }
    elsif ($input eq 'ORGANIZATION') {
	print $l1;
	&organization($error, $l2);
	print $l3."\n";
    }
    elsif ($input eq 'INSTITUTE') {
	if($config_display_form{'PERSON_INSTITUTE'}) {
	    print $l1;
	    &institute($error, $l2);
	    print $l3."\n";
	}
    }

}



################################################################################

sub gender {
    my ($error, $l2) = @_;

    &print_option('GENDER');

    print "$l2";
    if($q->param('step') > 0) {
	unless(&check_gender()) {
	    print "Please select ...";
	}
    }
}

sub check_gender {
    
    my @values = $q->param('GENDER');
    my $zeile;

    # ist Wert angegeben?
    if((@values == 0) 
       || ((@values == 1) && ($values[0] eq ''))) {

	# muss Wert ausgewaehlt sein?
	if($config_display_form{'PERSON_GENDER'}) {
	    return(0);
	}
    }
    else {
	# Sind es Werte aus vorgebener Liste
	foreach $zeile (@values) {
	    unless(&is_in_array($zeile, @{$config_display_form{'GENDER_params'}})) {
		return(0); # nicht vordefinierte Wert!
	    }
	}
	return(1);
    }

    return(0);
}

#-------------------------------------------------------------------------------------------
sub surname {
    my ($error, $l2) = @_;
    my $value = $q->param('SURNAME') || '';
    chomp($value);

    print "<INPUT TYPE=\"text\" NAME=\"SURNAME\" SIZE=\"".$config_input{'SURNAME_MAX_LENGTH'}
    ."\" value=\"".$value.'">';

    print "$l2";
    if($q->param('step') > 0) {
	unless(&check_surname($value)) {
	    print "Please check ... (ASCII only)";
	}
    }
}

sub check_surname {
    my ($value) = @_;
    
    if($value =~ m/^\w{2,}$/io) {
	return(1);
    }

    return(0);
}

#-------------------------------------------------------------------------------------------
sub firstname {
    my ($error, $l2) = @_;
    my $value = $q->param('FIRSTNAME') || '';
    chomp($value);

    print "<INPUT TYPE=\"text\" NAME=\"FIRSTNAME\" SIZE=\"".$config_input{'FIRSTNAME_MAX_LENGTH'}
    ."\" value=\"".$value.'">';

    print "$l2";
    if($q->param('step') > 0) {
	unless(&check_firstname($value)) {
	    print "Please check ... (ASCII only)";
	}
    }

}

sub check_firstname {
    my ($value) = @_;
    
    if($value =~ m/^\w{2,}$/io) {
	return(1);
    }

    return(0);
}



#-------------------------------------------------------------------------------------------
sub title {
    my ($error, $l2) = @_;
    my $value = $q->param('TITLE') || '';
    chomp($value);

    print "<INPUT TYPE=\"text\" NAME=\"TITLE\" SIZE=\"".$config_input{'TITLE_MAX_LENGTH'}
    ."\" value=\"".$value.'">';

    print "$l2";
    if($q->param('step') > 0) {
	unless(&check_title($value)) {
	    print "Please check ... (ASCII only)";
	}
    }


}


sub check_title {
    my ($value) = @_;
    
    #keiner Angegeben
    if ($value eq '') {
	    return(1);
    }

    if($value =~ m/^\w{2,}$/io) {
	return(1);
    }

    return(0);
}


#-------------------------------------------------------------------------------------------
sub organization {
    my ($error, $l2) = @_;
    my $value = $q->param('ORGANIZATION') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="ORGANIZATION" '
	.'SIZE="'.$config_input{'ORGANIZATION_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'ORGANIZATION_MAX_LENGTH'}.'" '
	.'value="'.$value.'">';


    print "$l2";
    if($q->param('step') > 0) {
	unless(&check_organization($value)) {
	    print "Please check ... (ASCII only)";
	}
    }
}

sub check_organization {
    my ($value) = @_;
    
    # wenn Daten angegeben, dann muessen diese auch dem Schema entsprechen
    if ($value eq '') {
	unless($config_display_form{'PERSON_ORGANIZATION'}) {
	    return(1);
	}
    }

    if($value =~ m/^[\w\d\s]{2,}$/io) {
	return(1);
    }

    return(0);
}



#-------------------------------------------------------------------------------------------
sub institute {
    my ($error, $l2) = @_;
    my $value = $q->param('INSTITUTE') || '';
    chomp($value);

    print "<INPUT TYPE=\"text\" NAME=\"INSTITUTE\" "
	.'SIZE="'.$config_input{'INSTITUTE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'INSTITUTE_MAX_LENGTH'}.'" '
	.'value="'.$value.'">';
    print "$l2";
    if($q->param('step') > 0) {
	unless(&check_institute($value)) {
	    print "Please check ... (ASCII only)";
	}
    }
}

sub check_institute {
    my ($value) = @_;
    
    if ($value eq '') {
	unless($config_display_form{'PERSON_INSTITUTE'}) {
	    return(1);
	}
    }
    if($value =~ m/^[\w\d\s]{2,}$/io) {
	return(1);
    }

    return(0);
}





#-------------------------------------------------------------------------------------------
sub print_option {
    my ($param) = @_;

    my $zeile;
    my @params = @{$config_display_form{'GENDER_params'}};
    my @value = $q->param($param);
    
    print "<SELECT NAME=\"".$param."\">\n";
    foreach $zeile (@params) {
	if (&is_in_array($zeile, @value)) {
	    print '<OPTION value="'.$zeile.'" SELECTED>'.$zeile."</OPTION>\n";
	}
	else {
	    print '<OPTION value="'.$zeile.'">'.$zeile."</OPTION>\n";
	}
    }
    print "</SELECT>\n";

}





# don't forget the return value ;-)
1;
