package modules::Person;

###################################################
#
#  Person Formfields
#
###################################################

use strict;
use locale;

use CGI qw(:standard :escapeHTML);
use modules::Config;
use modules::Design;
use modules::Subfunctions;
use modules::HTML_Functions;


require Exporter;
use vars  qw(@ISA @EXPORT $VERSION
	     &formular_person
	     &formular_person_check
	     
	     &person_gender
	     &person_gender_check
	     &person_title
	     &person_title_check
	     &person_firstname
	     &person_firstname_check
	     &person_surname
	     &person_surname_check
	     &person_organization
	     &person_organization_check
	     &person_institute
	     &person_institute_check
	     );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &formular_person
	     &formular_person_check
	     
	     &person_gender
	     &person_gender_check
	     &person_title
	     &person_title_check
	     &person_firstname
	     &person_firstname_check
	     &person_surname
	     &person_surname_check
	     &person_organization
	     &person_organization_check
	     &person_institute
	     &person_institute_check
	     );

$VERSION = 0.1;


my $q;

####################################################
#
####################################################


sub formular_person {
    ($q) = @_;
    my $zeile;

    my $l1;
    my $l2;
    my $l3;
    my $input;
    my $error;

    open(TEMPLATE, "< $config{'template_person'}") 
	|| die ("Template $config{'template_person'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)(<!--\s*### \w+ ###\s*-->)(.*)$/iog) {
	    $l1 = $1;
	    $input = $2;
	    $l2 = $3;
	    $error = $4;
	    $l3 = $5;
	    if(defined($error)) {
		if($zeile =~ m/^<!--\s*### (\w+) ###\s*-->$/iog) {
		   $error = $1;
	       }
	    }
	    &print_formular($input, $l1, $l2, $error, $l3);
	}
	else {
	    print $zeile;
	}
    }       


}


################################################################################

sub print_formular {
    my ($input, $l1, $l2, $error, $l3) = @_;

    if ($input eq 'GENDER') {
#	if($config_display_form{'PERSON_GENDER'}) {
	    print $l1;
	    &person_gender($error, $l2);
	    print $l3."\n";
#	}
    }
    elsif ($input eq 'SURNAME') {
#	if($config_display_form{'PERSON_SURNAME'}) {
	    print $l1;
	    &surname($error, $l2);
	    print $l3."\n";
#	}
    }
    elsif ($input eq 'FIRSTNAME') {
#	if($config_display_form{'PERSON_FIRSTNAME'}) {
	    print $l1;
	    &firstname($error, $l2);
	    print $l3."\n";
#	}
    }
    elsif ($input eq 'TITLE') {
#	if($config_display_form{'PERSON_TITLE'}) {
	    print $l1;
	    &title($error, $l2);
	    print $l3."\n";
#	}
    }
    elsif ($input eq 'ORGANIZATION') {
	print $l1;
	&organization($error, $l2);
	print $l3."\n";
    }
    elsif ($input eq 'INSTITUTE') {
#	if($config_display_form{'PERSON_INSTITUTE'}) {
	    print $l1;
	    &institute($error, $l2);
	    print $l3."\n";
#	}
    }

}



################################################################################

sub person_gender {
    my ($q) = @_;

    &print_option($q, 'GENDER');
    if($config_display_form{'PERSON_GENDER'}) {
	&red_star();
    }

#    if(defined($q->param('step')) && ($q->param('step') > 0)) {
#	unless(&person_gender_check()) {
#	    print "Please select ...";
#	}
#    }

}

sub person_gender_check {
    my ($q, $verbose) = @_;
 
    my @values = $q->param('GENDER');
    my $zeile;

    # ist Wert angegeben?
    if((@values == 0) 
       || ((@values == 1) && ($values[0] eq ''))) {

	# muss Wert ausgewaehlt sein
	if($config_display_form{'PERSON_GENDER'}) {
	    &print_error($verbose, $config_messages{'CHECK'});
	    return(1);
	}
    }
    else {
	# Sind es Werte aus vorgebener Liste
	foreach $zeile (@values) {
	    unless(&is_in_array($zeile, @{$config_display_form{'GENDER_params'}})) {
		&print_error($verbose, $config_messages{'CHECK'});
		return(1); # nicht vordefinierte Wert!
	    }
	}
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub person_surname {
    my ($q) = @_;
    my $value = $q->param('SURNAME') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="SURNAME" '
	.'SIZE="'.$config_input{'SURNAME_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'SURNAME_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'PERSON_SURNAME'}) {
	&red_star();
    }

}

sub person_surname_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('SURNAME') || '';
    chomp($value);

#    print "$l2";
#    if(defined($q->param('step')) && ($q->param('step') > 0)) {
#	unless(&check_surname()) {
#	    print "Please check ... (ASCII only)";
#	}
#    }

#    if($value =~ m/^[\w\s\-\'\"äöüßÄÖÜ]{2,}$/io) {
    unless($value =~ m/\d+/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub person_firstname {
    my ($q) = @_;
    my $value = $q->param('FIRSTNAME') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="FIRSTNAME" '
	.'SIZE="'.$config_input{'FIRSTNAME_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'FIRSTNAME_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'PERSON_FIRSTNAME'}) {
	&red_star();
    }

#    print "$l2";
#    if(defined($q->param('step')) && ($q->param('step') > 0)) {
#	unless(&check_firstname()) {
#	    print "Please check ... (ASCII only)";
#	}
#    }

}

sub person_firstname_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('FIRSTNAME') || '';
    chomp($value);
    
#    if($value =~ m/^[\wäöüßÄÖÜ\s\-]{2,}$/io) {
    unless($value =~ m/\d+/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}



#'-------------------------------------------------------------------------------------------
sub person_title {
    my ($q) = @_;
    my $value = $q->param('TITLE') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="TITLE" '
	.'SIZE="'.$config_input{'TITLE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'TITLE_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'PERSON_TITLE'}) {
	&red_star();
    }

}


sub person_title_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('TITLE') || '';
    chomp($value);
    
    #keine Angaben
    if ($value eq '') {
	    return(0);
    }

    if((length($value) < $config_input{'TITLE_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'TITLE_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

    if($value =~ m/\w+/io) {
	if($value =~ m/^[\w\s\.\-]+$/io) {
	    return(0);
	}
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}


#'-------------------------------------------------------------------------------------------
sub person_organization {
    my ($q) = @_;
    my $value = $q->param('ORGANIZATION') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="ORGANIZATION" '
	.'SIZE="'.$config_input{'ORGANIZATION_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'ORGANIZATION_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'PERSON_ORGANIZATION'}) {
	&red_star();
    }
}

sub person_organization_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('ORGANIZATION') || '';
    chomp($value);
    
    # wenn Daten angegeben, dann muessen diese auch dem Schema entsprechen
    if ($value eq '') {
	unless($config_display_form{'PERSON_ORGANIZATION'}) {
	    return(0);
	}
    }

    if((length($value) < $config_input{'ORGANIZATION_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'ORGANIZATION_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }
    else {
	# quasi nur länge prüfen
	return(0);
    }

#    if($value =~ m/^[\w\d\s\-\+\$\%\&\(\)\=\?\!\"\'äöüßÄÖÜ]+$/io) {
#	return(0);
#    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}



#'-------------------------------------------------------------------------------------------
sub person_institute {
    my ($q) = @_;
    my $value = $q->param('INSTITUTE') || '';
    chomp($value);

    print "<INPUT TYPE=\"text\" NAME=\"INSTITUTE\" "
	.'SIZE="'.$config_input{'INSTITUTE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'INSTITUTE_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'PERSON_INSTITUTE'}) {
	&red_star();
    }

}

sub person_institute_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('INSTITUTE') || '';
    chomp($value);
    
#    if ($value eq '') {
#	unless($config_display_form{'PERSON_INSTITUTE'}) {
#	    return(0);
#	}
#    }
    if((length($value) < $config_input{'INSTITUTE_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'INSTITUTE_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }
    else {
	# quasi nur länge prüfen
	return(0);
    }


#    if($value =~ m/^[\w\d\s\-\+\$\%\&\(\)\=\?\!\"\'äöüßÄÖÜ]+$/io) {
#	return(0);
#    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}





#-------------------------------------------------------------------------------------------
sub print_option {
    my ($q, $param) = @_;

    my $zeile;
    my @params = @{$config_display_form{'GENDER_params'}};
    my @value = $q->param($param);
    
    print "<SELECT NAME=\"".$param."\">\n";
    foreach $zeile (@params) {
	if (&is_in_array($zeile, @value)) {
	    print '<OPTION value="'.escapeHTML($zeile).'" SELECTED>'.escapeHTML($zeile)."</OPTION>\n";
	}
	else {
	    print '<OPTION value="'.escapeHTML($zeile).'">'.escapeHTML($zeile)."</OPTION>\n";
	}
    }
    print "</SELECT>\n";
}





sub formular_person_check {
    ($q) = @_;

    unless (&check_institute()) {
	return(0);
    }
    unless (&check_gender()) {
	return(0);
    }
    unless (&check_surname()) {
	return(0);
    }
    unless (&check_firstname()) {
	return(0);
    }
    unless (&check_title()) {
	return(0);
    }
    unless (&check_organization()) {
	return(0);
    }
    unless (&check_institute()) {
	return(0);
    }

    return(1);
}




# don't forget the return value ;-)
1;
