package modules::Payment;

###################################################
#
#
###################################################

use strict;
use locale;

use modules::Config;
use modules::HTML_Functions;
use modules::Subfunctions;
use modules::Design;


require Exporter;
use vars  qw(@ISA @EXPORT $VERSION
	     &formular_payment
	     &formular_payment_check
	     
	     &payment_payment
	     &payment_payment_check
	     );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &formular_payment
	     &formular_payment_check

	     &payment_payment
	     &payment_payment_check
	     );

$VERSION = 0.1;


my $q;

####################################################
#
####################################################

sub formular_payment {
    ($q) = @_;
    my $zeile;

    my $l1;
    my $l2;
    my $l3;
    my $input;
    my $error;

    open(TEMPLATE, "< $config{'template_payment'}") ||
	die ("Template $config{'template_payment'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)(<!--\s*### \w+ ###\s*-->)(.*)$/iog) {
	    $l1 = $1;
	    $input = $2;
	    $l2 = $3;
	    $error = $4;
	    $l3 = $5;
	    if(defined($error)) {
		if($zeile =~ m/^<!--\s*### (\w+) ###\s*-->$/iog) {
		   $error = $1;
	       }
	    }
	    &print_formular($input, $l1, $l2, $error, $l3);
	}
	else {
	    print $zeile;
	}
    }       


}


################################################################################

sub print_formular {
    my ($input, $l1, $l2, $error, $l3) = @_;

    if ($input eq 'PAYMENT') {
	if($config_display_form{'PAYMENT'}) {
	    print $l1;
	    &payment($error, $l2);
	    print $l3."\n";
	}
    }
}



################################################################################

sub payment_payment {
    my ($q) = @_;

    my @params = @{$config_display_form{'PAYMENT_params'}};
    my @value = $q->param('PAYMENT');

    if($config_display_form{'PAYMENT'}) {
	&red_star();
	print "<br>\n";
    }

    &print_radio('PAYMENT', \@params, \@value);

}



sub payment_payment_check {
    my ($q, $verbose) = @_;
    
    my @values = $q->param('PAYMENT');
    my $zeile;

    # ist Wert angegeben?
    if((@values == 0) 
       || ((@values == 1) && ($values[0] eq ''))) {

	# muss Wert ausgewaehlt sein?
	if($config_display_form{'PAYMENT'}) {
	    &print_error($verbose, $config_messages{'CHECK'});
	    return(1);
	}
    }
    else {
	# Sind es Werte aus vorgebener Liste
	foreach $zeile (@values) {
	    unless(&is_in_array($zeile, @{$config_display_form{'PAYMENT_params'}})) {
		&print_error($verbose, $config_messages{'CHECK'});
		return(1); # nicht vordefinierte Wert!
	    }
	}
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}




sub formular_payment_check {
    ($q) = @_;

    unless (&check_payment()) {
	return(0);
    }
    return(1);
}





# don't forget the return value ;-)
1;
