package modules::Options;

###################################################
#
#
###################################################

use strict;
use locale;

use modules::Config;
use modules::HTML_Functions;
use modules::Design;
use modules::Subfunctions;


require Exporter;
use vars  qw(@ISA @EXPORT $VERSION
	     &options_options
	     &options_options_check
	     );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &options_options
	     &options_options_check
	     );

$VERSION = 0.1;


#my $q;

####################################################
#
####################################################

################################################################################

sub print_formular {
    my ($input, $l1, $l2, $error, $l3) = @_;

    if ($input eq 'OPTIONS') {
	if($config_display_form{'OPTIONS'}) {
	    print $l1;
	    &options($error, $l2);
	    print $l3."\n";
	}
    }
}



################################################################################

sub options_options {
    my ($q, $param) = @_;

    my @params = @{$config_display_form{$param.'_params'}};
    my @value = $q->param($param);

    if($config_display_form{$param}) {
	&red_star();
	print "<br>\n";
    }

    if($config_display_form{$param.'_TYPE'} eq 'RADIO') {
	&print_radio($param, \@params, \@value);
    }
    elsif($config_display_form{$param.'_TYPE'} eq 'CHECKBOX') {
	&print_checkbox($param, \@params, \@value);
    }    


}



sub options_options_check {
    my ($q, $verbose, $param) = @_;

    my @keys;
    my $zeile;

    if ($param eq 'ALL') {
	my @tmp = keys(%config_display_form);
	foreach $zeile (@tmp) {
	    if ($zeile =~ m/^OPTION\d+$/) {
		push(@keys, $zeile);
	    }
	}
    }
    else {
	push(@keys, $param);
    }
    
    foreach $param (@keys) {
	$param =~ s/ERROR_//;
	my @values = $q->param($param);

	# ist Wert angegeben?
	if((@values == 0) 
	   || ((@values == 1) && ($values[0] eq ''))) {
	    
	    # muss Wert ausgewaehlt sein?
	    if($config_display_form{$param} == 1) {
		&print_error($verbose, $config_messages{'CHECK'});
		return(1);
	    }
	    elsif($config_display_form{$param} == 0) {
		return(0);
	    }
	}
	else {
	    # Sind es Werte aus vorgebener Liste
	    foreach $zeile (@values) {
		unless(&is_in_array($zeile, @{$config_display_form{$param.'_params'}})) {
		    &print_error($verbose, $config_messages{'CHECK'});
		    return(1); # nicht vordefinierte Wert!
		}
	    }
	    return(0);
	}
	
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}






# don't forget the return value ;-)
1;
