package modules::HTML_Functions;

###################################################
#
#
###################################################

use strict;

use modules::Subfunctions;

require Exporter;
use vars  qw(@ISA @EXPORT $VERSION
	     &print_radio
	     &print_checkbox
	     &print_error
	     );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &print_radio
	     &print_checkbox
	     &print_error
	     );

$VERSION = 0.1;


my $q;

####################################################
#
####################################################


#-------------------------------------------------------------------------------------------
sub print_radio {
    my ($name, $params, $value) = @_;

    my $zeile;
    
    foreach $zeile (@{$params}) {
	if (&is_in_array($zeile, @{$value})) {
	    print '<INPUT TYPE="radio" name="'.$name.'" value="'.$zeile.'" CHECKED>'.$zeile."<br>\n";
	}
	else {
	    print '<INPUT TYPE="radio" name="'.$name.'" value="'.$zeile.'">'.$zeile."<br>\n";
	}
    }

}
#-------------------------------------------------------------------------------------------
sub print_checkbox {
    my ($name, $params, $value) = @_;

    my $zeile;
    
    foreach $zeile (@{$params}) {
	if (&is_in_array($zeile, @{$value})) {
	    print '<INPUT TYPE="checkbox" name="'.$name.'" value="'.$zeile.'" CHECKED>'.$zeile."<br>\n";
	}
	else {
	    print '<INPUT TYPE="checkbox" name="'.$name.'" value="'.$zeile.'">'.$zeile."<br>\n";
	}
    }

}

sub print_error {
    my ($verbose, $message) = @_;

    if ($verbose eq 'p') {
	print "<font color=\"red\">$message</font>";
    }	

}



# don't forget the return value ;-)
1;
