package modules::Formular;

###################################################
#
#
###################################################

use strict;
use CGI qw(:standard :escapeHTML);

use modules::Config;

use modules::Address;
use modules::Person;
use modules::Registration;
use modules::Payment;
use modules::Options;
use modules::Database;
use modules::Email;



require Exporter;
use vars  qw(@ISA @EXPORT $VERSION
	     &formular_process
	     );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &formular_process
	     );

$VERSION = 0.1;

################################################################################
#
################################################################################

sub formular_process {
    my ($q) = @_;

    my $error = 0;
    my $write_db_error = 0;
    my $zeile;
    my $step = $q->param('step') || 0;

    if(defined($q->param('back'))) {
	$step -= 2;
    }

    if ($step > 0) {
	$error = &formular_error_check($q, 'ALL', 'q');
    }


    if ($step == 2) {
	# registration & email
	$write_db_error = &write_db($q);
	if($write_db_error == 3) {
	    print $config_messages{'NO_REC_TECPROB'};
	}
	elsif($write_db_error == 2) {
	    print $config_messages{'RE_REGISTRATION'};
	}
	elsif($write_db_error == 1) {
	    print $config_messages{'REG_SUCCESS'};
	}
	elsif($write_db_error == 0) {
	    #&formular_registration($q);
	    if(&send_email($q)) {
		print $config_messages{'REG_SUCCESS'};
	    }
	    else {
		print $config_messages{'REG_MAIL_PROB'};
	    }
	}


    }
    else {
	# fill in 
	open(TEMPLATE, "< $config{'template_formular'}") 
	    || die ("Template $config{'template_formular'} not found.");
	
	while ( $zeile = <TEMPLATE> ) {
	    if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/iog) {
		print $1;
		unless(&formular_process_parameter($q, $error, $2)) {
		    print '<!-- ### '.$2.' ### -->';
		    }
		print $3."\n";
	    }
	    else {
		print $zeile;
	    }
	}       
    }

    return(1);
}



################################################################################
sub formular_process_parameter {
    my ($q, $error, $param) = @_;

    my $exec = 0;
    my $step = $q->param('step') || 0;
    if(defined($q->param('back'))) {
	$step -= 2;
    }

    if ($step == 0) {
	$exec += &formular_input($q, $param);
	$step = 1;
    }
    elsif (($step == 1) && ($error != 0)) {
	$exec += &formular_input($q, $param);
	$exec += &formular_error_print($q, $param);
	$step = 1;
    }
    elsif (($step == 1) && ($error == 0)) {
	# confirm
	$exec += &formular_confirm($q, $param);
	$step = 2;
    }
    # step == 2 in aufrufender Funktion

    ##########
    if($param eq 'FORM_BEGIN') {
	$exec += &formular_form_begin();
    }
    elsif ($param eq 'FORM_END') {
	$exec += &formular_form_end();
    }
    elsif ($param eq 'SUBMIT') {
	if ($step == 2) {
	    $exec += &formular_submit('CONFIRM', $step);
	}
	else {
	    $exec += &formular_submit('SUBMIT', $step);
	}
    }
    elsif ($param eq 'CONFIRM') {
	$exec += &formular_submit('CONFIRM', $step);
    }

    if ($param eq 'BACK') {
	if($step > 1) {
	    $exec += &formular_back();
	}
	else {
	    $exec += &formular_reset();
	}
    }
    
    return($exec);
}




##############################
sub formular_form_begin {

    print '<form action="'.$ENV{'SCRIPT_NAME'}.'" method="POST" enctype="multipart/form-data">'."\n";
    return(1);
}

##############################
sub formular_form_end {
    print "</form>\n";
    return(1);
}

##############################
sub formular_submit {
    my ($func, $step) = @_;

    if ($func eq 'CONFIRM') {
	print "<input type=\"submit\" name=\"submit\" value=\"Confirm >>>\">\n";
    }
    else {
	print "<input type=\"submit\" name=\"submit\" value=\"Submit this Form >>>\">\n";
    }

    print '<input type="hidden" name="step" value="'.$step."\">\n";
    return(1);
}

##############################
sub formular_back {
    print "<input type=\"submit\" name=\"back\" value=\"<<< Correct\">\n";
    return(1);
}
##############################
sub formular_reset {
    print "<input type=\"reset\" name=\"reset\" value=\"Reset Form\">\n";
    return(1);
}




################################################################################
# q quiet
# p print out
sub formular_error_check {
    my ($q, $param, $verbose) = @_;

    my $error = 0;

    # check parameter
    if ($param eq 'ERROR_GENDER' || $param eq 'ALL') {
	$error += &person_gender_check($q, $verbose);
    }
    if ($param eq 'ERROR_TITLE' || $param eq 'ALL') {
	$error += &person_title_check($q, $verbose);
    }
    if ($param eq 'ERROR_FIRSTNAME' || $param eq 'ALL') {
	$error += &person_firstname_check($q, $verbose);
    }
    if ($param eq 'ERROR_SURNAME' || $param eq 'ALL') {
	$error += &person_surname_check($q, $verbose);
    }
    if ($param eq 'ERROR_ORGANIZATION' || $param eq 'ALL') {
	$error += &person_organization_check($q, $verbose);
    }
    if ($param eq 'ERROR_INSTITUTE' || $param eq 'ALL') {
	$error += &person_institute_check($q, $verbose);
    }
    
    if ($param eq 'ERROR_STREET' || $param eq 'ALL') {
	$error += &address_street_check($q, $verbose);
    }
    if ($param eq 'ERROR_TOWN' || $param eq 'ALL') {
	$error += &address_town_check($q, $verbose);
    }
    if ($param eq 'ERROR_POSTCODE' || $param eq 'ALL') {
	$error += &address_postcode_check($q, $verbose);
    }
    if ($param eq 'ERROR_STATE' || $param eq 'ALL') {
	$error += &address_state_check($q, $verbose);
    }
    if ($param eq 'ERROR_COUNTRY' || $param eq 'ALL') {
	$error += &address_country_check($q, $verbose);
    }
    if ($param eq 'ERROR_PHONE_OFFICE' || $param eq 'ALL') {
	$error += &address_phone_office_check($q, $verbose);
    }
    if ($param eq 'ERROR_PHONE_SECRETARY' || $param eq 'ALL') {
	$error += &address_phone_secretary_check($q, $verbose);
    }
    if ($param eq 'ERROR_FAX' || $param eq 'ALL') {
	$error += &address_fax_check($q, $verbose);
    }
    if ($param eq 'ERROR_EMAIL' || $param eq 'ALL') {
	$error += &address_email_check($q, $verbose);
    }
    if ($param eq 'ERROR_WEBSITE' || $param eq 'ALL') {
	$error += &address_website_check($q, $verbose);
    }
    if ($param eq 'ERROR_PAYMENT' || $param eq 'ALL') {
	$error += &payment_payment_check($q, $verbose);
    }
    if (($param =~ m/^ERROR_OPTION\d+$/) || $param eq 'ALL') {
	$error += &options_options_check($q, $verbose, $param);
    }

    return ($error);
}


################################################################################
sub formular_input {
    my ($q, $param) = @_;

    # plain formular
    if ($param eq 'GENDER') {
	&person_gender($q);
    }
    elsif ($param eq 'TITLE') {
	&person_title($q);
    }
    elsif ($param eq 'FIRSTNAME') {
	&person_firstname($q);
    }
    elsif ($param eq 'SURNAME') {
	&person_surname($q);
    }
    elsif ($param eq 'ORGANIZATION') {
	&person_organization($q);
    }
    elsif ($param eq 'INSTITUTE') {
	&person_institute($q);
    }
    
    elsif ($param eq 'STREET') {
	&address_street($q);
    }
    elsif ($param eq 'TOWN') {
	&address_town($q);
    }
    elsif ($param eq 'POSTCODE') {
	&address_postcode($q);
    }
    elsif ($param eq 'STATE') {
	&address_state($q);
    }
    elsif ($param eq 'COUNTRY') {
	&address_country($q);
    }
    elsif ($param eq 'PHONE_OFFICE') {
	&address_phone_office($q);
    }
    elsif ($param eq 'PHONE_SECRETARY') {
	&address_phone_secretary($q);
    }
    elsif ($param eq 'FAX') {
	&address_fax($q);
    }
    elsif ($param eq 'EMAIL') {
	&address_email($q);
    }
    elsif ($param eq 'WEBSITE') {
	&address_website($q);
    }
    elsif ($param eq 'PAYMENT') {
	&payment_payment($q);
    }
    elsif ($param =~ m/^OPTION\d+$/) {
	&options_options($q, $param);
    }

    else {
	return(0);
    }

    return(1);
}


################################################################################
sub formular_error_print {
    my ($q, $param) = @_;
    
    # ERROR_CHECK
    if ($param eq 'ERROR_GENDER') {
	&person_gender_check($q, 'p');
    }
    elsif ($param eq 'ERROR_TITLE') {
	&person_title_check($q, 'p');
    }
    elsif ($param eq 'ERROR_FIRSTNAME') {
	&person_firstname_check($q, 'p');
    }
    elsif ($param eq 'ERROR_SURNAME') {
	&person_surname_check($q, 'p');
    }
    elsif ($param eq 'ERROR_ORGANIZATION') {
	&person_organization_check($q, 'p');
    }
    elsif ($param eq 'ERROR_INSTITUTE') {
	&person_institute_check($q, 'p');
    }
    
    elsif ($param eq 'ERROR_STREET') {
	&address_street_check($q, 'p');
    }
    elsif ($param eq 'ERROR_TOWN') {
	&address_town_check($q, 'p');
    }
    elsif ($param eq 'ERROR_POSTCODE') {
	&address_postcode_check($q, 'p');
    }
    elsif ($param eq 'ERROR_STATE') {
	&address_state_check($q, 'p');
    }
    elsif ($param eq 'ERROR_COUNTRY') {
	&address_country_check($q, 'p');
    }
    elsif ($param eq 'ERROR_PHONE_OFFICE') {
	&address_phone_office_check($q, 'p');
    }
    elsif ($param eq 'ERROR_PHONE_SECRETARY') {
	&address_phone_secretary_check($q, 'p');
    }
    elsif ($param eq 'ERROR_FAX') {
	&address_fax_check($q, 'p');
    }
    elsif ($param eq 'ERROR_EMAIL') {
	&address_email_check($q, 'p');
    }
    elsif ($param eq 'ERROR_WEBSITE') {
	&address_website_check($q, 'p');
    }
    elsif ($param eq 'ERROR_PAYMENT') {
	&payment_payment_check($q, 'p');
    }
    elsif ($param =~ m/^ERROR_OPTION\d+$/) {
	&options_options_check($q, 'p', $param);
    }


    else {
	return(0);
    }

    return(1);
}


################################################################################
sub formular_confirm {
    my ($q, $param) = @_;

    # plain formular
    if ($param eq 'GENDER') {
	print $q->param('GENDER');
	print "<input type=\"hidden\" name=\"GENDER\" value=\"".escapeHTML($q->param('GENDER'))."\">";
    }
    elsif ($param eq 'TITLE') {
	print $q->param('TITLE');
	print "<input type=\"hidden\" name=\"TITLE\" value=\"".escapeHTML($q->param('TITLE'))."\">";
    }
    elsif ($param eq 'FIRSTNAME') {
	print $q->param('FIRSTNAME');
	print "<input type=\"hidden\" name=\"FIRSTNAME\" value=\"".escapeHTML($q->param('FIRSTNAME'))."\">";
    }
    elsif ($param eq 'SURNAME') {
	print $q->param('SURNAME');
	print "<input type=\"hidden\" name=\"SURNAME\" value=\"".escapeHTML($q->param('SURNAME'))."\">";
    }
    elsif ($param eq 'ORGANIZATION') {
	print $q->param('ORGANIZATION');
	print "<input type=\"hidden\" name=\"ORGANIZATION\" value=\"".escapeHTML($q->param('ORGANIZATION'))."\">";
    }
    elsif ($param eq 'INSTITUTE') {
	print $q->param('INSTITUTE');
	print "<input type=\"hidden\" name=\"INSTITUTE\" value=\"".escapeHTML($q->param('INSTITUTE'))."\">";
    }
    
    elsif ($param eq 'STREET') {
	print $q->param('STREET');
	print "<input type=\"hidden\" name=\"STREET\" value=\"".escapeHTML($q->param('STREET'))."\">";
    }
    elsif ($param eq 'TOWN') {
	print $q->param('TOWN');
	print "<input type=\"hidden\" name=\"TOWN\" value=\"".escapeHTML($q->param('TOWN'))."\">";
    }
    elsif ($param eq 'POSTCODE') {
	print $q->param('POSTCODE');
	print "<input type=\"hidden\" name=\"POSTCODE\" value=\"".escapeHTML($q->param('POSTCODE'))."\">";
    }
    elsif ($param eq 'STATE') {
	print $q->param('STATE');
	print "<input type=\"hidden\" name=\"STATE\" value=\"".escapeHTML($q->param('STATE'))."\">";
    }
    elsif ($param eq 'COUNTRY') {
	print $q->param('COUNTRY');
	print "<input type=\"hidden\" name=\"COUNTRY\" value=\"".escapeHTML($q->param('COUNTRY'))."\">";
    }
    elsif ($param eq 'PHONE_OFFICE') {
	print $q->param('PHONE_OFFICE');
	print "<input type=\"hidden\" name=\"PHONE_OFFICE\" value=\"".escapeHTML($q->param('PHONE_OFFICE'))."\">";
    }
    elsif ($param eq 'PHONE_SECRETARY') {
	print $q->param('PHONE_SECRETARY');
	print "<input type=\"hidden\" name=\"PHONE_SECRETARY\" value=\"".escapeHTML($q->param('PHONE_SECRETARY'))."\">";
    }
    elsif ($param eq 'FAX') {
	print $q->param('FAX');
	print "<input type=\"hidden\" name=\"FAX\" value=\"".escapeHTML($q->param('FAX'))."\">";
    }
    elsif ($param eq 'EMAIL') {
	print $q->param('EMAIL');
	print "<input type=\"hidden\" name=\"EMAIL\" value=\"".escapeHTML($q->param('EMAIL'))."\">";
    }
    elsif ($param eq 'WEBSITE') {
	unless($q->param('WEBSITE') =~ m/^http:\/\//) {
	    print $q->param('WEBSITE');
	    print "<input type=\"hidden\" name=\"WEBSITE\" value=\"".escapeHTML($q->param('WEBSITE'))."\">";
	}
    }
    elsif ($param eq 'PAYMENT') {
	print $q->param('PAYMENT');
	print "<input type=\"hidden\" name=\"PAYMENT\" value=\"".escapeHTML($q->param('PAYMENT'))."\">";
    }
    elsif ($param =~ m/OPTION\d+/) {
	if($config_display_form{$param.'_TYPE'} eq 'RADIO') {
	    print $q->param($param);
	    print "<input type=\"hidden\" name=\"$param\" value=\"".escapeHTML($q->param($param))."\">";
	}
	elsif ($config_display_form{$param.'_TYPE'} eq 'CHECKBOX') {
	    my @tmp = $q->param($param);

	    foreach (@tmp) {
		print "$_ <input type=\"hidden\" name=\"$param\" value=\"".escapeHTML($_)."\"><br>\n";
	    }
	}
    }

    else {
	return(0);
    }

    return(1);
}



#
1;
