package modules::Email;

###################################################
#
#
###################################################

use strict;

#use utf8;
#use charnames qw(:full);
#use byte;

use modules::Config;
#use CGI qw(:escapeHTML);

require Exporter;
use vars qw(@ISA @EXPORT $VERSION
	    &send_email
	    );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &send_email
	     );

$VERSION = 0.1;


####################################################
#
####################################################

sub send_email {
    my ($q) = @_;
    
    my $zeile;

    # Open The Mail Program
    open(MAIL,"|$config{'mailprog'}") || return(0);
    
    open(TEMPLATE , "<$config{'template_email'}") || die ("Template $config{'template_email'} not found.");

    while ( $zeile = <TEMPLATE> ) {
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/) {
	    do {
		$zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/;
		$zeile = $1.&email_print_parameter($q, $2).$3;

	    } 
	    until(!($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)$/));
		    
#	    $zeile =~ tr/\0-\xff//CU;       # Latin -> UTF8
#	    $zeile =~ tr/\0-\x{ff}//UC;       # UTF8 -> Iso-Latin-1

	    print MAIL $zeile."\n";
	}
	else {
	    print MAIL $zeile;
	}
    }       

    close(TEMPLATE);
    close(MAIL);

    return(1);
}


################################################################################
sub email_print_parameter {
    my($q, $param) = @_;

        # plain formular
    if ($param eq 'GENDER') {
	return($q->param('GENDER'));
    }
    elsif ($param eq 'TITLE') {
	return($q->param('TITLE'));
    }
    elsif ($param eq 'FIRSTNAME') {
	return($q->param('FIRSTNAME'));
    }
    elsif ($param eq 'SURNAME') {
	return($q->param('SURNAME'));
    }
    elsif ($param eq 'ORGANIZATION') {
	return($q->param('ORGANIZATION'));
    }
    elsif ($param eq 'INSTITUTE') {
	return($q->param('INSTITUTE'));
    }
    
    elsif ($param eq 'STREET') {
	return($q->param('STREET'));
    }
    elsif ($param eq 'TOWN') {
	return($q->param('TOWN'));
    }
    elsif ($param eq 'POSTCODE') {
	return($q->param('POSTCODE'));
    }
    elsif ($param eq 'STATE') {
	return($q->param('STATE'));
    }
    elsif ($param eq 'COUNTRY') {
	return($q->param('COUNTRY'));
    }
    elsif ($param eq 'PHONE_OFFICE') {
	return($q->param('PHONE_OFFICE'));
    }
    elsif ($param eq 'PHONE_SECRETARY') {
	return($q->param('PHONE_SECRETARY'));
    }
    elsif ($param eq 'FAX') {
	return($q->param('FAX'));
    }
    elsif ($param eq 'EMAIL') {
	return($q->param('EMAIL'));
    }
    elsif ($param eq 'WEBSITE') {
	unless($q->param('WEBSITE') =~ m/^http:\/\//) {
	    return($q->param('WEBSITE'));
	}
    }
    elsif ($param eq 'PAYMENT') {
	return($q->param('PAYMENT'));
    }
    elsif ($param =~ m/OPTION\d+/) {
	if($config_display_form{$param.'_TYPE'} eq 'RADIO') {
	    return($q->param($param));
	}
	elsif ($config_display_form{$param.'_TYPE'} eq 'CHECKBOX') {
	    my @tmp = $q->param($param);
	
	    return(join('; ', @tmp));
	}
    }

    else {
	return(0);
    }

    return(1);
}


#
1;
