package modules::Database;

###################################################
#
#
###################################################

use strict;

use DB_File;
use Time::localtime;
use modules::Config;

require Exporter;
use vars qw(@ISA @EXPORT $VERSION
	    &write_db
	    );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &write_db
	     );

$VERSION = 0.1;


####################################################
#
# 0 i.O.
# 1 vor x Sekunden eingetragen (Browser-Reload)
# 2 schon eingetragen
####################################################

sub write_db {
    my ($q) = @_;
    my @array;
    
    my $i;
    my $zeile_neu = '';
    my $time = time();
    my $ftime;
    my $pos = 0;
    my $zeile;

    $zeile_neu .= $q->param('GENDER')."\t"
	.$q->param('SURNAME')."\t"
	.$q->param('FIRSTNAME')."\t"
	.$q->param('TITLE')."\t"
	.$q->param('ORGANIZATION')."\t"
	.$q->param('INSTITUTE')."\t"
	.$q->param('TOWN')."\t"
	.$q->param('STREET')."\t"
	.$q->param('POSTCODE')."\t"
	.$q->param('STATE')."\t"
	.$q->param('COUNTRY')."\t"
	.$q->param('PHONEOFFICE')."\t"
	.$q->param('SECRETARY')."\t"
	.$q->param('FAX')."\t"
	.$q->param('EMAIL')."\t"
	.$q->param('WEBSITE')."\t"
	.$q->param('PAYMENT')."\t";

    # get all Options
    my @tmp = keys(%config_display_form);
    my @keys;
    my @tmp2;
    my $tmp = '';
    foreach $zeile (@tmp) {
	if ($zeile =~ m/^OPTION\d+$/) {
	    push(@keys, $zeile);
	}
    }
    foreach $zeile (@keys) {
	@tmp2 = $q->param($zeile); 
	$tmp .= " $zeile: ".join(';', @tmp2);
    }

    # concat options
    $zeile_neu .= $tmp;

    tie(@array, "DB_File", $database_file, O_RDWR|O_CREAT, 0666, $DB_RECNO)
	|| die ("Unable to open $database_file");

    # nachschauen ob eintrag schon existiert
    for($i=0; $i < @array; $i++) {
	$pos = index($array[$i], $q->param('SURNAME')."\t".$q->param('FIRSTNAME'), $pos);
	if($pos > 0) {
	    $pos = index($array[$i], $q->param('TITLE'), $pos);
	    if($pos > 0) {
		$pos = index($array[$i], $q->param('TOWN')."\t".$q->param('STREET'), $pos);
		if($pos > 0) {
		    $pos = index($array[$i], $q->param('EMAIL'), $pos);
		    if($pos > 0) {
			# wenn Daten durch Seiten-reload innerhalb kurzer Zeit wiederholt gesendet werden
			# so soll nix geschehen
			$array[$i] =~ m/^(\d+)\s+/;
			$ftime = $1;
			untie(@array);
			if (($time - $ftime) < 60) {
			    return(1);
			}
			else {
			    return (2);
			}
		    }
		}
	    }
	}
    }

    push(@array, $time."\t".$zeile_neu);
    untie(@array);

    return(0);
}



# don't forget the return value ;-)
1;
