# Config.pm
package modules::Config;

###################################################
#
#  Parameter Configuration
#
###################################################

use strict;
require Exporter;
use vars qw(@ISA @EXPORT $VERSION

	    %config
	    %config_gender
	    %config_display_form
	    %config_input
	    %config_messages

	    $database_file
	    );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     %config
	     %config_gender
	     %config_display_form
	     %config_input
	     %config_messages

	    $database_file
	     );

$VERSION = 0.1;



################################################################################
#
# change Parameter here
#
################################################################################

$database_file = './db/bail05.txt';

%config = ('template_file'            => './templates/formular/bail05.html',
	   'template_formular'        => './templates/formular/formular.html',

	   'template_email'           => './templates/formular/email.txt',
	   'mailprog'                 => '/usr/sbin/sendmail -t',

	   'regnumber_file'           => './templates/regnumber.dat',
);

my @gender_params = ('', 'Mr.', 'Mrs.', 'Ms.');
my @payment_params = ('Bank transfer', 'Cash at registration');
my @option1_params = ('Info 1', 
		      'Info 2',
		      'Info 3',
		      'Dinner');
my @option2_params = ('Vorlesung 1', 
		      'Vorlesung 2',
		      'Vorlesung 3',
		      'Vorlesung 4');
my @option3_params = ('H&uuml;hnchen', 
		      'Fisch',
		      'Vegetarisch');


%config_input = ('SURNAME_MIN_LENGTH'       => 3,
		 'SURNAME_MAX_LENGTH'       => 50,
		 'FIRSTNAME_MIN_LENGTH'     => 3,
		 'FIRSTNAME_MAX_LENGTH'     => 50,
		 'TITLE_MIN_LENGTH'         => 3,
		 'TITLE_MAX_LENGTH'         => 30,
		 'INSTITUTE_MIN_LENGTH'     => 3,
		 'INSTITUTE_MAX_LENGTH'     => 40,
		 'ORGANIZATION_MIN_LENGTH'  => 3,
		 'ORGANIZATION_MAX_LENGTH'  => 40,

		 'STREET_MIN_LENGTH'  => 3,
		 'STREET_MAX_LENGTH'  => 40,
		 'TOWN_MIN_LENGTH'  => 3,
		 'TOWN_MAX_LENGTH'  => 40,
		 'POSTCODE_MIN_LENGTH'  => 3,
		 'POSTCODE_MAX_LENGTH'  => 8,
		 'STATE_MIN_LENGTH'  => 3,
		 'STATE_MAX_LENGTH'  => 40,

		 'COUNTRY_MIN_LENGTH'  => 3,
		 'COUNTRY_MAX_LENGTH'  => 40,

		 'PHONEOFFICE_MIN_LENGTH'  => 3,
		 'PHONEOFFICE_MAX_LENGTH'  => 40,
		 'SECRETARY_MIN_LENGTH'  => 3,
		 'SECRETARY_MAX_LENGTH'  => 40,
		 'FAX_MIN_LENGTH'  => 3,
		 'FAX_MAX_LENGTH'  => 40,
		 'EMAIL_MIN_LENGTH'  => 3,
		 'EMAIL_MAX_LENGTH'  => 40,
		 'WEBSITE_MIN_LENGTH'  => 3,
		 'WEBSITE_MAX_LENGTH'  => 50,


);

# 1 : Wert muss angegeben werden
# 0 : Wert kann angegeben werden 
%config_display_form = ('PERSON'               => 1,
			        'PERSON_GENDER'        => 1,
			               'GENDER_params'        => \@gender_params,
			        'PERSON_SURNAME'       => 1,
			        'PERSON_FIRSTNAME'     => 1,
			        'PERSON_TITLE'         => 0,
			        'PERSON_ORGANIZATION'  => 0,
			        'PERSON_INSTITUTE'     => 1,

			'ADDRESS'              => 1,
			        'ADDRESS_TOWN'         => 1,
			        'ADDRESS_STREET'       => 1,
			        'ADDRESS_POSTCODE'     => 1,
			        'ADDRESS_STATE'        => 1,
			        'ADDRESS_COUNTRY'      => 0,
			        'ADDRESS_PHONEOFFICE'  => 0,
			        'ADDRESS_SECRETARY'    => 0,
			        'ADDRESS_FAX'          => 0,
			        'ADDRESS_EMAIL'        => 1,
			        'ADDRESS_WEBSITE'      => 0,
			'PAYMENT'              => 1,
			        'PAYMENT_params'       => \@payment_params,
			'OPTION1'              => 0,
			        'OPTION1_TYPE'         => 'RADIO',        # only one can be selected
			        'OPTION1_params'       => \@option1_params,
			'OPTION2'              => 1,
			        'OPTION2_TYPE'         => 'CHECKBOX',       # multiple selection possible
			        'OPTION2_params'       => \@option2_params,
			'OPTION3'              => 1,
			        'OPTION3_TYPE'         => 'RADIO',       # multiple selection possible
			        'OPTION3_params'       => \@option3_params,
			'REGISTRATION'         => 1);


%config_messages = ('FILL_IN'           => 'Please fill in',
		    'CHECK'             => 'Please check',
		    'NO_REG_TECPROB'	=> "<p>No registration.</p>\nTechnical Promblems\n",
		    'RE_REGISTRATION'   => "<p>You are already registrated.</p>\n",
		    'REG_SUCCESS'       => "<p>Thank you for registration.</p>\n",
		    'REG_MAIL_PROB'     => "<p>You are registrated. Sending E-Mail to your Account failed.</p>\n"
		    );


# don't forget the return value ;-)
1;
