package modules::Address;

###################################################
#
#  Address Formfields
#
###################################################

use strict;

use CGI qw(:standard :escapeHTML);
use modules::Config;
use modules::Design;
use modules::HTML_Functions;

require Exporter;
use vars  qw(@ISA @EXPORT $VERSION
	     &formular_address
	     &formular_address_check
	     
	     &address_street
	     &address_street_check
	     &address_town
	     &address_town_check
	     &address_postcode
	     &address_postcode_check
	     &address_state
	     &address_state_check
	     &address_country
	     &address_country_check
	     &address_phone_office
	     &address_phone_office_check
	     &address_phone_secretary
	     &address_phone_secretary_check
	     &address_fax
	     &address_fax_check
	     &address_email
	     &address_email_check
	     &address_website
	     &address_website_check
	     );


@ISA    = qw(Exporter);
@EXPORT = qw(
	     &formular_address
	     &formular_address_check
	     
	     &address_street
	     &address_street_check
	     &address_town
	     &address_town_check
	     &address_postcode
	     &address_postcode_check
	     &address_state
	     &address_state_check
	     &address_country
	     &address_country_check
	     &address_phone_office
	     &address_phone_office_check
	     &address_phone_secretary
	     &address_phone_secretary_check
	     &address_fax
	     &address_fax_check
	     &address_email
	     &address_email_check
	     &address_website
	     &address_website_check
	     );

$VERSION = 0.1;

my $q;


####################################################
#
####################################################

sub formular_address {
    ($q) = @_;
    my $zeile;

    my $l1;
    my $l2;
    my $l3;
    my $input;
    my $error;

    open(TEMPLATE, "< $config{'template_address'}") or die ("Template $config{'template_address'} not found.");
    
    while ( $zeile = <TEMPLATE> ) {
	if ($zeile =~ m/^(.*)<!--\s*### (\w+) ###\s*-->(.*)(<!--\s*### \w+ ###\s*-->)(.*)$/iog) {
	    $l1 = $1;
	    $input = $2;
	    $l2 = $3;
	    $error = $4;
	    $l3 = $5;
	    if(defined($error)) {
		if($zeile =~ m/^<!--\s*### (\w+) ###\s*-->$/iog) {
		   $error = $1;
	       }
	    }
	    &print_formular($input, $l1, $l2, $error, $l3);
	}
	else {
	    print $zeile;
	}
    }       
}



sub print_formular {
    my ($input, $l1, $l2, $error, $l3) = @_;

    print $l1;
    if ($input eq 'STREET') {
	&street($error, $l2);
    }
    elsif ($input eq 'TOWN') {
	&town($error, $l2);
    }
    elsif ($input eq 'POSTCODE') {
	&postcode($error, $l2);
    }
    elsif ($input eq 'STATE') {
	&state($error, $l2);
    }
    elsif ($input eq 'PHONEOFFICE') {
	&phoneoffice($error, $l2);
    }
    elsif ($input eq 'SECRETARY') {
	&secretary($error, $l2);
    }
    elsif ($input eq 'FAX') {
	&fax($error, $l2);
    }
    elsif ($input eq 'EMAIL') {
	&email($error, $l2);
    }
    elsif ($input eq 'WEBSITE') {
	    &website($error, $l2);
    }
    print $l3."\n";

}



#-------------------------------------------------------------------------------------------
sub address_street {
    my ($q) = @_;

    my $value = $q->param('STREET') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="STREET" '
	.'SIZE="'.$config_input{'STREET_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'STREET_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_STREET'}) {
	&red_star();
    }
}

sub address_street_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('STREET') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_STREET'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'STREET_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'STREET_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }
    else {
	# quasi nur laenge pruefen
	return(0);}

#    if($value =~ m/^[\w\s\d\-\+\/\\'\"äöüßÄÖÜ]+$/io) {
#	return(0);
#    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub address_town {
    my ($q) = @_;
    my $value = $q->param('TOWN') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="TOWN" '
	.'SIZE="'.$config_input{'TOWN_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'TOWN_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_TOWN'}) {
	&red_star();
    }

}

sub address_town_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('TOWN') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_TOWN'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'TOWN_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'TOWN_MAX_LENGTH'})) {
        &print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }
    else {
	# quasi nur laenge pruefen
	return(0);
    }

#    if($value =~ m/^[\w\s\-\'\"äöüßÄÖÜ]+$/io) {
#	return(0);
#    }
	
    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#'-------------------------------------------------------------------------------------------
sub address_postcode {
    my ($q) = @_;
    my $value = $q->param('POSTCODE') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="POSTCODE" '
	.'SIZE="'.$config_input{'POSTCODE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'POSTCODE_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_POSTCODE'}) {
	&red_star();
    }
}

sub address_postcode_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('POSTCODE') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_POSTCODE'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'POSTCODE_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'POSTCODE_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

    if($value =~ m/^[\d\w\-\s]+$/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub address_state {
    my ($q) = @_;
    my $value = $q->param('STATE') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="STATE" '
	.'SIZE="'.$config_input{'STATE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'STATE_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_STATE'}) {
	&red_star();
    }
}

sub address_state_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('STATE') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_STATE'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'STATE_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'STATE_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }
    else {
	# quasi nur laenge pruefen
	return(0);
    }

#    if($value =~ m/^[\w\s\-]{2,}$/io) {
#	return(0);
#    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub address_country {
    my ($q) = @_;
    my $value = $q->param('COUNTRY') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="COUNTRY" '
	.'SIZE="'.$config_input{'STATE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'STATE_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_COUNTRY'}) {
	&red_star();
    }
}

sub address_country_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('COUNTRY') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_COUNTRY'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'COUNTRY_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'COUNTRY_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }
    else {
	# quasi nur laenge pruefen
	return(0);
    }

#    if($value =~ m/^[\w\s\-]{2,}$/io) {
#	return(0);
#    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub address_phone_office {
    my ($q) = @_;
    my $value = $q->param('PHONEOFFICE') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="PHONEOFFICE" '
	.'SIZE="'.$config_input{'PHONEOFFICE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'PHONEOFFICE_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_PHONEOFFICE'}) {
	&red_star();
    }
}

sub address_phone_office_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('PHONEOFFICE') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_PHONEOFFICE'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'STATE_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'STATE_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

    if($value =~ m/^[\s\d\-\+\/\\]*$/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}

#-------------------------------------------------------------------------------------------
sub address_phone_secretary {
    my ($q) = @_;
    my $value = $q->param('SECRETARY') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="SECRETARY" '
	.'SIZE="'.$config_input{'SECRETARY_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'SECRETARY_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_SECRETARY'}) {
	&red_star();
    }
}

sub address_phone_secretary_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('SECRETARY') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_SECRETARY'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'SECRETARY_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'SECRETARY_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

    if($value =~ m/^[\s\d\-\+\/\\]*$/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}


#-------------------------------------------------------------------------------------------
sub address_fax {
    my ($q) = @_;
    my $value = $q->param('FAX') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="FAX" '
	.'SIZE="'.$config_input{'FAX_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'FAX_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_FAX'}) {
	&red_star();
    }
}

sub address_fax_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('FAX') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_FAX'} == 0)) {
	    return(0);
    }

    if((length($value) < $config_input{'FAX_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'FAX_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

    if($value =~ m/^[\s\d\-\+\/\\]*$/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(0);
}


#-------------------------------------------------------------------------------------------
sub address_email {
    my ($q) = @_;
    my $value = $q->param('EMAIL') || '';
    chomp($value);

    print '<INPUT TYPE="text" NAME="EMAIL" '
	.'SIZE="'.$config_input{'EMAIL_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'EMAIL_MAX_LENGTH'}.'" '
	.'value="'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_EMAIL'}) {
	&red_star();
    }
}

sub address_email_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('EMAIL') || '';
    chomp($value);
    
    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_EMAIL'} == 1)) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

#    if ($value !~ m/(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)/ 
#	|| $value =~ m/^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/) {
    if($value =~ m/^([^@])+@(.)+\.(.){2,4}$/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}


#-------------------------------------------------------------------------------------------
sub address_website {
    my ($q) = @_;
    my $value = $q->param('WEBSITE') || '';
    chomp($value);
    $value =~ s/^http:\/\///i;

    print '<INPUT TYPE="text" NAME="WEBSITE" '
	.'SIZE="'.$config_input{'WEBSITE_MAX_LENGTH'}.'" '
	.'MAXLENGTH="'.$config_input{'WEBSITE_MAX_LENGTH'}.'" '
	.'value="http://'.escapeHTML($value).'">';

    if($config_display_form{'ADDRESS_WEBSITE'}) {
	&red_star();
    }
}

sub address_website_check {
    my ($q, $verbose) = @_;

    my $value = $q->param('WEBSITE') || '';
    chomp($value);
    
    $value =~ s/^http:\/\///i;

    #keiner Angaben
    if (($value eq '') && ($config_display_form{'ADDRESS_WEBSITE'} == 0)) {
	return(0);
    }

    if((length($value) < $config_input{'FAX_MIN_LENGTH'}) 
	|| (length($value) > $config_input{'FAX_MAX_LENGTH'})) {
	&print_error($verbose, $config_messages{'CHECK'});
	return(1);
    }

    if($value =~ m/^([^@])+\.(.){2,4}(.*)$/io) {
	return(0);
    }

    &print_error($verbose, $config_messages{'CHECK'});
    return(1);
}



#
#--------------------------------------------------------------------------------
#
sub formular_address_check {
    ($q) = @_;

    unless (&check_street()) {
	print "Street";
	return(0);
    }
    unless (&check_town()) {
	print "town";
	return(0);
    }
    unless (&check_postcode()) {
	print "postcode";
	return(0);
    }
    unless (&check_state()) {
	print "state";
	return(0);
    }
    unless (&check_phoneoffice()) {
	print "phoneoffice";
	return(0);
    }
    unless (&check_secretary()) {
	print "secretary";
	return(0);
    }
    unless (&check_fax()) {
	print "fax";
	return(0);
    }
    unless (&check_email()) {
	print "mail";
	return(0);
    }
    unless (&check_website()) {
	print "website";
	return(0);
    }

    return(1);
}






# don't forget the return value ;-)
1;
